/* <nagg02.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library g02 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2156 (Feb 1998).
 * Mark 6 revised. IER-3041 (July 2000).
 * Echo 10/22/04 NAG_ILLEGAL_ARGUMENTS 

 */
#ifndef NAGG02
#define NAGG02

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* Message codes and extern of message list */
#include "nag_g02mesg.h"
  /* begin proto */
  extern void g02aaw_f(Integer n, Integer ia, double a[]);
  extern void g02aax_f(const char *uplo, Integer n, const double a[], double b[],
                       Integer uplo_len);
  extern void g02aax(MatrixTriangle uplo, Integer n, double *a, double *b);
  extern void g02aay_f(const char *uplo, const char *diag, Integer n, double a[],
                       Integer uplo_len, Integer diag_len);
  extern void g02aay(MatrixTriangle uplo, MatrixUnitTriangular diag, Integer n,
                     double *a);
  extern void g02aaz_f(const char *uplo, const char *diag, Integer n, double a[],
                       Integer uplo_len, Integer diag_len);
  extern void g02aaz(MatrixTriangle uplo, MatrixUnitTriangular diag, Integer n,
                     double *a);
  extern NAG_DLL_EXPIMP void NAG_CALL g02brc(Integer n, Integer m, double x[], Integer tdx, 
                                             Integer svar[], Integer sobs[], double corr[], 
                                             Integer tdc, NagError *fail);
  extern   NAG_DLL_EXPIMP void NAG_CALL g02btc(Nag_SumSquare mean, Integer m, double wt, const double x[], Integer incx, double *sw, double xbar[], double c[], NagError *fail); 


  extern  NAG_DLL_EXPIMP void NAG_CALL g02buc(Nag_OrderType order, Nag_SumSquare mean, Integer n, Integer m, const double x[], Integer pdx, const double wt[], double *sw, double wmean[], double c[], NagError *fail); 


  extern NAG_DLL_EXPIMP void NAG_CALL g02buc_0(Nag_IncludeMean mean, Integer n, Integer m, double x[],
                     Integer tdx, double wt[], double *sw, double wmean[],
                     double c[], NagError *fail);

  extern void g02buf_f(const char *mean, const char *weight, Integer n, Integer m,
                       const double x[], Integer ldx, const double wt[], double *sw,
                       double wmean[], double c[], Integer *ifail, Integer mean_len,
                       Integer weight_len);

extern  NAG_DLL_EXPIMP void NAG_CALL g02bwc(Integer m, double r[], NagError *fail); 


  extern void g02bwf_f(Integer m, double r[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02bxc(Integer n, Integer m, double x[], 
                                             Integer tdx, Integer sx[], double wt[], double *sw, 
                                             double wmean[], double std[], double r[], Integer tdr,
                                             double v[], Integer tdv, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02bxf_f(const char *weight, Integer n, Integer m, const double x[],
                       Integer ldx, const double wt[], double xbar[], double std[],
                       double v[], Integer ldv, double r[], Integer *ifail,
                       Integer weight_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g02byc(Integer m, Integer ny, Integer nx, const Integer isz[],
                     const double r[], Integer ldr, double p[], Integer ldp,
                     NagError *fail);
  extern void g02byf_f(Integer m, Integer ny, Integer nx, const Integer isz[],
                       const double r[], Integer ldr, double p[], Integer ldp,
                       double wk[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02cac(Nag_SumSquare mean, Integer n, 
                                             double x[], double y[], double wt[], double *a, double *b, 
                                             double *a_serr, double *b_serr, double *rsq, double *rss,
                                             double *df, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02caf_f(Integer n, const double x[], const double y[], double result[],
                       Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02cbc(Nag_SumSquare mean, Integer n, double x[], double y[],
                                             double wt[], double clm, double clp, double yhat[],
                                             double yml[], double ymu[], double yl[], double yu[],
                                             double h[], double res[], double *rms, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dac(Nag_IncludeMean mean,Integer n,double x[], Integer tdx,Integer m,
                                             Integer sx[], Integer ip, double y[], double wt[], double *rss,
                                             double *df, double b[], double se[], double cov[], double res[],
                                             double h[], double q[], Integer tdq, Boolean *svd, Integer *rank,
                                             double p[], double tol, double com_ar[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02daf_f(const char *mean, const char *weight, Integer n, const double x[],
                       Integer ldx, Integer m, const Integer isx[], Integer ip,
                       const double y[], const double wt[], double *rss, Integer *idf,
                       double b[], double se[], double cov[], double res[],
                       double h[], double q[], Integer ldq, Boolean *svd,
                       Integer *irank, double p[], double tol, double wk[],
                       Integer *ifail, Integer mean_len, Integer weight_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dcc(Nag_UpdateObserv update, Nag_IncludeMean mean, Integer m,
                                             Integer sx[], double q[], Integer tdq, Integer ip,
                                             double x[],  Integer nr, Integer tdx, Integer  ix,
                                             double y, double *wt, double *rss, NagError *fail);
  extern void g02dcz(Integer n, double alpha, double x[], Integer  incx, double a[],
                     Integer tda, double c[], double s[], double *zeta);
  extern NAG_DLL_EXPIMP void NAG_CALL g02ddc(Integer n,Integer ip, double q[], Integer tdq, double *rss,
                                             double *df, double b[], double se[], double cov[], Boolean *svd,
                                             Integer *rank,double p[], double tol, NagError *fail);
  extern void g02ddf_f(Integer n, Integer ip, const double q[], Integer ldq,
                       double *rss, Integer *idf, double b[], double se[],
                       double cov[], Boolean *svd, Integer *irank, double p[],
                       double tol, double wk[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dec(Integer n, Integer ip, double q[], Integer tdq, double p[],
                                             double wt[], double x[], double *rss, double tol, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dfc(Integer ip, double q[], Integer tdq, Integer indx, double *rss,
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dgc(Integer n,double wt[], double *rss, Integer ip, Integer rank,
                                             double cov[], double q[], Integer tdq, Boolean svd, double p[],
                                             double y[], double b[], double se[], double res[],
                                             double com_ar[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dgf_f(const char *weight, Integer n, const double wt[], double *rss,
                       Integer ip, Integer irank, double cov[], double q[],
                       Integer ldq, Boolean svd, const double p[], const double y[],
                       double b[], double se[], double res[], double wk[],
                       Integer *ifail, Integer weight_len);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dkc(Integer ip, Integer iconst, double p[], double c[],
                                             Integer tdc, double b[], double rss, double df,
                                             double se[], double cov[], NagError *fail);
  extern void g02dkz(Integer ip, Integer iconst, double p[], Integer imp,
                     double c[], Integer tdc, double b[], double s,
                     double se[], double cov[], Integer *ind);
  extern NAG_DLL_EXPIMP void NAG_CALL g02dnc(Integer ip, Integer rank, double b[], double cov[],
                                             double p[], double f[], Boolean *est, double *stat,
                                             double *sestat, double *t, double tol, NagError *fail);
  extern void g02dnz(Integer ip, Integer rank, double b[], double cov[], double p[],
                     Integer imp, double f[], Boolean *est, double *stat,
                     double *sestat, double *t, double tol, Integer *ind);
  extern Integer g02eaz_f (Integer m, Integer n, Integer *ifail);
  extern Integer g02eaz(Integer m, Integer n, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02fac(Integer n, Integer ip, Integer nres, double res[], double h[],
                                             double rms, double sres[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g02eac(Nag_OrderType order, Nag_IncludeMean mean, Integer n, Integer m, const double x[], Integer pdx, const char *var_names[], const Integer sx[], const double y[], const double wt[], Integer *nmod, const char *model[], double rss[], Integer nterms[], Integer mrank[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g02ecc(Nag_IncludeMean mean, Integer n, double sigsq, double tss, Integer nmod, const Integer nterms[], const double rss[], double rsq[], double cp[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g02eec(Nag_OrderType order, Integer *istep, Nag_IncludeMean mean, Integer n, Integer m, const double x[], Integer pdx, const char *vname[], const Integer sx[], Integer maxip, const double y[], const double wt[], double fin, Boolean *addvar, const char *newvar[], double *chrss, double *f, const char *model[], Integer *nterm, double *rss, Integer *idf, Integer *ifr, const char *free_vars[], double exss[], double q[], Integer pdq, double p[], NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g02fcc(Integer n, Integer p, const double res[], double *d, double *pdl, double *pdu, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g02gac(Nag_Link link, Nag_IncludeMean mean, Integer n, double x[],
                                             Integer tdx, Integer m, Integer sx[], Integer ip, double y[],
                                             double wt[], double offset[], double *scale, double ex_power,
                                             double *rss, double *df, double b[], Integer *rank, double se[],
                                             double cov[], double v[], Integer tdv, double tol,
                                             Integer max_iter, Integer print_iter, const char *outfile, double eps,
                                             NagError *fail);
  extern double g02gav(double fv, double y, double *t);
  extern void g02gaw(Integer n, double fv[], double t[], double var[], double wt[], 
                     Integer no);
  extern NAG_DLL_EXPIMP void NAG_CALL g02gbc(Nag_Link link, Nag_IncludeMean mean, Integer n, double x[],
                                             Integer tdx, Integer m, Integer sx[], Integer ip, double y[],
                                             double binom_t[], double wt[], double offset[], double *dev,
                                             double *df, double b[], Integer *rank, double se[],
                                             double cov[], double v[], Integer tdv, double tol,
                                             Integer max_iter, Integer print_iter, const char *outfile,
                                             double eps, NagError *fail);
  extern void g02gbs_f(Integer ip, Integer irank, Boolean svd, const double q[],
                       Integer ldq, double cov[], double wk[]);
  extern void g02gbs(Integer ip, Integer rank, Boolean svd, double q[], Integer tdq,
                     double cov[], double wk[]);
  extern void g02gbt_f(const char *mean, Integer n, Integer m, const double x[],
                       Integer ldx, const Integer isx[], Integer ip, const double q[],
                       Integer ldq, Boolean svd, Integer irank, const double wwt[],
                       double h[], double wk[], Integer mean_len);
  extern void g02gbt(Nag_IncludeMean mean, Integer n, Integer m, double x[],
                     Integer tdx, Integer isx[], Integer ip,  double q[],
                     Integer tdq, Boolean svd, Integer rank, double wwt[], 
                     double h[], double wk[]);
  extern void g02gbu(Integer n, char link, double y[], double t[], double fv[], 
                     double eta[], double wt[], Integer no, Integer *ind);
  extern double g02gbv(double fv, double y, double *t);
  extern void g02gbw(Integer n,  double fv[], double t[], double var[], double wt[],
                     Integer no);
  extern void g02gbx(Integer n, char link, double eta[], double t[], double der[],
                     double a, double wt[], Integer no);
  extern void g02gby(Integer n, char link, double eta[], double fv[], double t[],
                     double *a, double wt[], Integer no, Integer *ind);
  ///Echo 10/22/04 NAG_ILLEGAL_ARGUMENTS 
  //extern void g02gbz_f(void (*clink)(Integer , const char *link, const double [], double [],
                                     //const double [], double , const double [], Integer ,
                                     //Integer *, Integer ),
                       //void (*cder)(Integer , const char *link, const double [], const double [],
                                    //double [], double , const double [], Integer ,
                                    //Integer ),
                       //double (*cdev)(double , double , double *),
                       //void (*cvar)(Integer , const double [], const double [], double [],
                                    //const double [], Integer ),
                       //const char *link, const char *mean, const char *weight, Integer n,
                       //const double x[], Integer ldx, Integer m, const Integer isx[],
                       //const double y[], double t[], const double wt[], Integer no,
                       //double *dev, Integer *irank, double b[], Integer ip,
                       //double fv[], double eta[], double var[], double wwt[],
                       //const double off[], double q[], Integer ldq, double a,
                       //Boolean *svd, double tol, Integer maxit, Integer *iter,
                       //Integer iprint, double eps, double wk[], Integer *ierror,
                       //Integer link_len, Integer mean_len, Integer weight_len);
  //extern void g02gbz(void (*clink) (Integer n, char link, double eta[], double fv[],
                                    //double t[], double *a, double wt[], Integer no, Integer *ind),
                     //void (*cder) (Integer n, char link, double eta[], double t[],
                                   //double der[], double a, double wt[], Integer no),
                     //double (*cdev) (double fv, double y, double *t),
                     //void (*cvar) (Integer n,  double fv[], double t[], double var[],
                                   //double wt[], Integer no),
                     //char link, Nag_IncludeMean mean, char weight, Integer n,
                     //double x[], Integer tdx, Integer m, Integer isx[], double y[],
                     //double t[], double wt[], Integer no, double *dev, Integer *rank,
                     //double b[], Integer ip, double fv[], double eta[], double var[],
                     //double wwt[], double off[], double q[], Integer tdq, double *a,
                     //Boolean *svd, double tol, Integer maxit, Integer *iter, 
  typedef void (*clink_v_v)(Integer , const char *link, const double [], double [],
                                     const double [], double , const double [], Integer ,
                                     Integer *, Integer );
  typedef void (*cder_v_v)(Integer , const char *link, const double [], const double [],
                                    double [], double , const double [], Integer ,
                                    Integer );
  typedef double (*cdev_d_v) (double fv, double y, double *t);
  typedef void (*cvar_v_v) (Integer n,  double fv[], double t[], double var[],
                                   double wt[], Integer no);
  extern void g02gbz_f(clink_v_v clink,
                       cder_v_v cder,
                       cdev_d_v cdev,
                       cvar_v_v cvar,
                       const char *link, const char *mean, const char *weight, Integer n,
                       const double x[], Integer ldx, Integer m, const Integer isx[],
                       const double y[], double t[], const double wt[], Integer no,
                       double *dev, Integer *irank, double b[], Integer ip,
                       double fv[], double eta[], double var[], double wwt[],
                       const double off[], double q[], Integer ldq, double a,
                       Boolean *svd, double tol, Integer maxit, Integer *iter,
                       Integer iprint, double eps, double wk[], Integer *ierror,
                       Integer link_len, Integer mean_len, Integer weight_len);
  extern void g02gbz(clink_v_v  clink,
                     cder_v_v cder,
                     cdev_d_v cdev,
                     cvar_v_v cvar,
                     char link, Nag_IncludeMean mean, char weight, Integer n,
                     double x[], Integer tdx, Integer m, Integer isx[], double y[],
                     double t[], double wt[], Integer no, double *dev, Integer *rank,
                     double b[], Integer ip, double fv[], double eta[], double var[],
                     double wwt[], double off[], double q[], Integer tdq, double *a,
                     Boolean *svd, double tol, Integer maxit, Integer *iter, 
                     Integer iprint, Nag_FileSt *stream, double eps, double wk[], Integer *ierror);
  ///END NAG_ILLEGAL_ARGUMENTS 
                   
  extern NAG_DLL_EXPIMP void NAG_CALL g02gcc(Nag_Link link, Nag_IncludeMean mean, Integer n, double x[],
                                             Integer tdx, Integer m, Integer sx[], Integer ip, double y[], 
                                             double wt[], double offset[], double ex_power, double *dev,
                                             double *df, double b[], Integer *rank, double se[], double cov[], 
                                             double v[], Integer tdv, double tol, Integer max_iter, 
                                             Integer print_iter, const char *outfile, double eps, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02gcf_f(const char *link, const char *mean, const char *offset, const char *weight,
                       Integer n, const double x[], Integer ldx, Integer m,
                       const Integer isx[], Integer ip, const double y[], const double wt[],
                       double a, double *dev, Integer *idf, double b[],
                       Integer *irank, double se[], double cov[], double v[],
                       Integer ldv, double tol, Integer maxit, Integer iprint,
                       double eps, double wk[], Integer *ifail, Integer link_len,
                       Integer mean_len, Integer offset_len, Integer weight_len);
  extern void g02gcu_f(Integer n, const char *link, double a, const double y[],
                       double fv[], double eta[], const double wt[], Integer no,
                       double ymin, double y0, Integer link_len);
  extern void g02gcu(Integer n, char link, double a, double y[], double fv[], 
                     double eta[], double wt[], Integer no, double ymin, double y0);
  extern double g02gcv_f(double fv, double y, double *t);
  extern double g02gcv(double fv, double y, double *t);
  extern void g02gcw_f(Integer n, const double fv[], const double t[], double var[],
                       const double wt[], Integer no);
  extern void g02gcw(Integer n,  double fv[], double t[], double var[],
                     double wt[],  Integer no);
  extern void g02gcx_f(Integer n, const char *link, const double eta[], const double t[],
                       double der[], double a, const double wt[], Integer no,
                       Integer link_len);
  extern void g02gcx(Integer n, char link, double eta[], double t[],
                     double der[], double a, double wt[], Integer no);
  extern void g02gcy_f(Integer n, const char *link, const double eta[], double fv[],
                       const double t[], double a, const double wt[], Integer no,
                       Integer *ind, Integer link_len);
  extern void g02gcy(Integer n, char link, double eta[], double fv[],
                     double t[], double *a, double wt[], Integer no,
                     Integer *ind);
  extern NAG_DLL_EXPIMP void NAG_CALL g02gdc(Nag_Link link, Nag_IncludeMean mean, Integer n, double x[],
                                             Integer tdx, Integer m, Integer sx[], Integer ip, double y[],
                                             double wt[], double offset[], double *scale, double ex_power,
                                             double *dev, double *df, double b[], Integer *rank, double se[],
                                             double cov[], double v[], Integer tdv, double tol,
                                             Integer max_iter, Integer print_iter, const char *outfile, double eps,
                                             NagError *fail);
  extern double g02gdv(double fv, double y, double *t);
  extern void g02gdw(Integer n,  double fv[], double t[], double var[],
                     double wt[],  Integer no);
  extern NAG_DLL_EXPIMP void NAG_CALL g02gkc(Integer ip, Integer nclin, double v[], Integer tdv, double c[],
                                             Integer tdc, double b[], double scale, double se[], double cov[],
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02gnc(Integer ip, Integer rank, double b[], double cov[], double v[],
                                             Integer tdv, double f[], Boolean *est, double *stat, 
                                             double *sestat, double *z, double tol, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g02hac(Nag_RegType regtype, Nag_PsiFun psifun, 
                                             Nag_SigmaEst sigma_est, Nag_CovMatrixEst covmat_est, Integer n, 
                                             Integer m, double x[], Integer tdx, double y[], 
                                             double cpsi, double hpsi[], double cucv, double dchi, 
                                             double theta[], double *sigma, double c[], Integer tdc, 
                                             double rs[], double wt[], double tol, Integer max_iter,
                                             Integer print_iter, const char *outfile, double info[], NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g02hbc(Nag_OrderType order,
                                             NAG_G02HBC_UCV, Integer n,
                                             Integer m, const double x[],
                                             Integer ix, double a[], double z[],
                                             double bl, double bd, double tol,
                                             Integer maxit, Integer nitmon,
                                             const char *outfile, Integer *nit,
                                             Nag_Comm *comm, NagError *fail); 

  extern NAG_DLL_EXPIMP void NAG_CALL g02hdc(Nag_OrderType order,
                                             NAG_G02HDC_CHI, NAG_G02HDC_PSI,
                                             double psip0, double beta,
                                             Nag_RegType regtype,
                                             Nag_SigmaEst sigma_est, Integer n,
                                             Integer m, double x[], Integer ix,
                                             double y[], double wgt[],
                                             double theta[], Integer *k,
                                             double *sigma, double rs[],
                                             double tol, double eps,
                                             Integer maxit, Integer nitmon,
                                             const char *outfile, Integer *nit,
                                             Nag_Comm *comm, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL g02hfc(Nag_OrderType order,
                                             NAG_G02HFC_PSI, NAG_G02HFC_PSP,
                                             Nag_RegType regtype,
                                             Nag_CovMatrixEst covmat_est,
                                             double sigma, Integer n, Integer m,
                                             const double x[], Integer ix,
                                             const double rs[],
                                             const double wgt[], double cov[],
                                             Integer ic, double comm_arr[],
                                             Nag_Comm *comm, NagError *fail);

  extern void g02hat(Integer isigma, Integer indw, Integer ipsi, Integer n, double d,
                     double wgt[], double *beta, Integer maxit, double tol,
                     double work[], Integer *ifail);
  extern double g02hau(double t, Integer ips, double c, double h1, double h2, double h3);
  extern double g02hav(double x, Integer ifun, double c);
  extern void g02haw(double x[], double a[], double cucv, Integer n, Integer m,
                     Integer mm, Integer mdx, Integer maxit, Integer nitmon,
                     Nag_FileSt *stream, double tol, Integer *nit, double sz[],
                     double sc2[], Integer ifun, Integer *ifail);
  extern void g02hax(Integer indw, Integer ipsi, Integer isigma, Integer n,
                     Integer m,  double x[],  Integer tdx,  double y[],
                     double beta, double cpsi, double h1, double h2,
                     double h3, double cucv, double d, double wgt[],
                     double theta[],  Integer *k,  double *sigma,
                     double rs[], double tol,  Integer maxit, Integer nitmon,
                     Nag_FileSt *stream, Integer *nit,  double wrk[],
                     Integer *ifail);
  extern void g02hay(Integer indw, Integer n, Integer m, double x[], Integer tdx,
                     Integer mm, double cucv, double wgt[], Integer maxit,
                     Integer nitmon, Nag_FileSt *stream, double tol, Integer *nit,
                     double sa[], double sz[], double sc2[], Integer *ifail);
  extern void g02haz(Integer indw, Integer ipsi, Integer indc, double sigma,
                     Integer n, Integer m,  double x[],  Integer tdx,
                     double rs[], double wgt[], double cpsi, double h1,
                     double h2, double h3, double c[],  Integer tdc,
                     double d[], double e[], double wk[],
                     Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL g02hkc(Integer n, Integer m, double x[], Integer tdx, 
                                             double eps, double cov[], double theta[], Integer max_iter,
                                             Integer print_iter, const char *outfile, double tol, Integer *iter, 
                                             NagError *fail);
  extern void g02hku(double t, double b[], double *u, double *ud,
                     double *w, double *wd);
  extern double g02hkv(double tau2, double xp, double a2, double b2);
  extern void g02hkw(double a2, double b2,  Integer nvar, double *t2);
  extern void g02hkx(double eps, double *c);
  extern double g02hky(double cap,  Integer nvar,  double tol);
  extern void g02hkz(double eps, Integer nvar, double *a2, double *b2);
  extern NAG_DLL_EXPIMP void NAG_CALL g02hlc(Nag_OrderType order, NAG_G02HLC_UCV, Integer indm, Integer n, Integer m, const double x[], Integer pdx, double cov[], double a[], double wt[], double theta[], double bl, double bd, Integer maxit, Integer nitmon, const char * outfile, double tol, Integer *nit, Nag_Comm *comm, NagError *fail);
  ///Echo 10/22/04 NAG_ILLEGAL_ARGUMENTS 
  //extern void g02hlc_0(void (*ucv) (double t, double userp[], double *u, double *ud, double *w, double *wd),  
                     //double userp[],  Integer indm, Integer n,
                     //Integer m,  double x[],  Integer tdx,  double cov[],
                     //double a[], double wt[], double theta[], double bl,
                     //double bd,  Integer maxit, Integer nitmon,  double tol,
                     //Integer *nit,  double wk[],  Nag_FileSt *stream, NagError *fail);
  typedef void (*ucv_v_v) (double t, double userp[], double *u, double *ud, double *w, double *wd);
  extern void g02hlc_0(ucv_v_v ucv,  
                     double userp[],  Integer indm, Integer n,
                     Integer m,  double x[],  Integer tdx,  double cov[],
                     double a[], double wt[], double theta[], double bl,
                     double bd,  Integer maxit, Integer nitmon,  double tol,
                     Integer *nit,  double wk[],  Nag_FileSt *stream, NagError *fail);
  ///end NAG_ILLEGAL_ARGUMENTS
extern NAG_DLL_EXPIMP void NAG_CALL g02hmc(Nag_OrderType order, NAG_G02HMC_UCV, Integer indm, Integer n, Integer m, const double x[], Integer pdx, double cov[], double a[], double wt[], double theta[], double bl, double bd, Integer maxit, Integer nitmon, const char * outfile, double tol, Integer *nit, Nag_Comm *comm, NagError *fail); 

  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGG02 */
